return {
    com = {
        ",",
        north = ";",
        alt_label = ";",
        northeast = "(",
        northwest = "¿",
        east = "„",
        west = "?",
    },
    prd = {
        ".",
        north = ":",
        alt_label = ":",
        northeast = ")",
        northwest = "¡",
        east = "…",
        west = "!",
    },
    _at = {
        "@",
        north = "Ⓒ",
        alt_label = "Ⓒ",
        northeast = "™",
        northwest = "Ⓡ",
    },
    _eq = {
        "=",
        north = "_",
        alt_label = "_",
        northwest = "-",
        west = "≈",
        south = "≥",
        southwest = "≤",
    },
    pco = { -- period + colon
        ".",
        north = ":",
        alt_label = ":",
        northeast = "'",
        northwest = "=",
        east = "!",
        west = "?",
        south = "|",
        southeast = "\\",
        southwest = "/",
        "·", -- Greek Ano Teleia
        "·", -- Middle Dot
        "&",
    },
    cop = { -- colon + period
        ":",
        north = ".",
        alt_label = ".",
        northeast = "'",
        northwest = "=",
        east = "!",
        west = "?",
        south = "|",
        southeast = "\\",
        southwest = "/",
        "·", -- Greek Ano Teleia
        "·", -- Middle Dot
        "&",
    },
    quo = {
        '"',
        north = "'",
        alt_label = "'",
        northeast = "»",
        northwest = "«",
        east = "”",
        west = "“",
        south = "`",
        southeast = "’",
        southwest = "‘",
        "‹",
        "›",
    },
    cse = { -- comma + semicolon
        ",",
        north = ";",
        alt_label = ";",
        northeast = "}",
        northwest = "{",
        east = { label = "!…", key = "!important;" },
        west = "-",
        south = "*",
        southwest = "0",
        southeast = ">",
        "[",
        "+",
        "]",
    },
    sec = { -- semicolon + comma
        ";",
        north = ",",
        alt_label = ",",
        northeast = "}",
        northwest = "{",
        east = { label = "!…", key = "!important;" },
        west = "-",
        south = "*",
        southwest = "0",
        southeast = ">",
        "[",
        "*",
        "]",
    },
    _A_el = {
        "Α",
        northeast = "Ἀ",
        north = "α",
        northwest = "Ἁ",
        east = "Ά",
        west = " ᾍ",
        south = "ᾼ",
        southeast = "Ἄ",
        southwest = "Ἅ",
        "Ἇ",
        "ᾏ",
        "Ἆ",
    },
    _a_el = {
        "α",
        northeast = "ἀ",
        north = "Α",
        northwest = "ἁ",
        east = "ά",
        west = "ὰ",
        south = "ᾳ",
        southeast = "ἄ",
        southwest = "ἅ",
        "ἇ",
        "ᾶ",
        "ἆ",
    },
    _B_el = {
        "Β",
        northeast = "♭",
        north = "β",
        northwest = "B", -- Latin capital letter B
    },
    _b_el = {
        "β",
        northeast = "♭",
        north = "Β",
        northwest = "b",
        west = "ϐ", -- Greek beta symbol
    },
    _C_el = {
        "Ψ",
        northeast = "©",
        north = "ψ",
        northwest = "C",
    },
    _c_el = {
        "ψ",
        northeast = "©",
        north = "Ψ",
        northwest = "c",
    },
    _D_el = {
        "Δ",
        north = "δ",
        northwest = "D",
    },
    _d_el = {
        "δ",
        north = "Δ",
        northwest = "d",
    },
    _E_el = {
        "Ε",
        northeast = "Ἐ",
        northwest = "Ἑ",
        north = "ε",
        east = "Έ",
        west = "Ὲ",
        south = "E", -- Latin capital letter E
        southeast = "Ἔ",
        southwest = "Ἕ",
        "€", -- Euro currency
    },
    _e_el = {
        "ε",
        northeast = "ἐ",
        north = "Ε",
        northwest = "ἑ",
        east = "έ",
        west = "ὲ",
        south = "e",
        southeast = "ἔ",
        southwest = "ἕ",
        "€", -- Euro currency
    },
    _F_el = {
        "Φ",
        northeast = "ƒ", -- Guilder/Florin
        north = "φ",
        northwest = "F",
    },
    _f_el = {
        "φ",
        northeast = "ƒ", -- Guilder/Florin
        north = "Φ",
        northwest = "f",
        west = "ϕ", -- Greek phi symbol
    },
    _G_el = {
        "Γ",
        north = "γ",
        northwest = "G",
    },
    _g_el = {
        "γ",
        north = "Γ",
        northwest = "g",
    },
    _H_el = {
        "Η",
        northeast = "Ἠ",
        northwest = "Ἡ",
        north = "η",
        east = "Ή",
        south = "ῌ",
        west = "Ὴ",
        southeast = "Ἤ",
        southwest = "Ἥ",
        "Ἧ",
        "ᾟ",
        "Ἦ",
    },
    _h_el = {
        "η",
        northeast = "ἠ",
        north = "Η",
        northwest = "ἡ",
        east = "ή",
        west = "ὴ",
        south = "ῃ",
        southeast = "ἤ",
        southwest = "ἥ",
        "ἧ",
        "ῆ",
        "ἦ",
    },
    _I_el = {
        "Ι",
        northeast = "Ἰ",
        north = "ι",
        northwest = "Ἱ",
        east = "Ί",
        west = "Ὶ",
        southeast = "Ἴ",
        southwest = "Ἵ",
        south = "I", -- Latin capital letter I
        "Ἷ",
        "Ϊ",
        "Ἶ",
    },
    _i_el = {
        "ι",
        northeast = "ἰ",
        north = "Ι",
        northwest = "ἱ",
        east = "ί",
        west = "ὶ",
        south = "ῗ",
        southeast = "ἴ",
        southwest = "ἵ",
        "ΐ",
        "ϊ",
        "ῖ",
    },
    _J_el = {
        "Ξ",
        north = "ξ",
        northwest = "J",
    },
    _j_el = {
        "ξ",
        north = "Ξ",
        northwest = "j",
    },
    _K_el = {
        "Κ",
        north = "κ",
        northwest = "K", -- Latin capital letter K
        northeast = "Ϗ", -- Greek capital kai symbol
    },
    _k_el = {
        "κ",
        north = "Κ",
        northwest = "k",
        northeast = "ϗ", -- Greek kai symbol
    },
    _L_el = {
        "Λ",
        north = "λ",
        northwest = "L",
    },
    _l_el = {
        "λ",
        north = "Λ",
        northwest = "l",
    },
    _M_el = {
        "Μ",
        north = "μ",
        northwest = "M", -- Latin capital letter M
    },
    _m_el = {
        "μ",
        north = "Μ",
        northwest = "m",
    },
    _N_el = {
        "Ν",
        north = "ν",
        northwest = "N", -- Latin capital letter N
    },
    _n_el = {
        "ν",
        north = "Ν",
        northwest = "n",
    },
    _O_el = {
        "Ο",
        northeast = "Ὀ",
        northwest = "Ὁ",
        north = "ο",
        east = "Ό",
        west = "Ὸ",
        south = "Ø",
        southeast = "Ὄ",
        southwest = "Ὅ",
        "O", -- Latin capital letter O
    },
    _o_el = {
        "ο",
        northeast = "ὀ",
        northwest = "ὁ",
        north = "Ο",
        east = "ό",
        west = "ὸ",
        south = "ø",
        southeast = "ὄ",
        southwest = "ὅ",
        "o", -- Latin small letter o
    },
    _P_el = {
        "Π",
        north = "π",
        northwest = "P", -- Latin capital letter P
    },
    _p_el = {
        "π",
        north = "Π",
        northwest = "p",
        west = "ϖ", -- Greek pi symbol
    },
    _Q_el = {
        "΄", -- Greek tonos
        alt_label = ";",
        north = ";", -- Greek question mark
        northeast = "Q",
        east = "Ϙ", -- Greek letter archaic koppa
    },
    _q_el = {
        ";", -- Greek question mark
        alt_label = "΄",
        north = "΄", -- Greek tonos
        northeast = "q",
        east = "ϙ", -- Greek small letter archaic koppa
    },
    _R_el = {
        "Ρ",
        north = "ρ",
        northeast = "Ῥ",
        northwest = "R",
    },
    _r_el = {
        "ρ",
        northwest = "ῥ",
        northeast = "ῤ",
        north = "Ρ",
        west = "r",
    },
    _S_el = {
        "Σ",
        north = "σ",
        northwest = "S",
    },
    _s_el = {
        "σ",
        northeast = "ς",
        north = "Σ",
        northwest = "s",
    },
    _T_el = {
        "Τ",
        north = "τ",
        northwest = "T", -- Latin capital letter T
    },
    _t_el = {
        "τ",
        north = "Τ",
        northwest = "t",
    },
    _U_el = {
        "Θ",
        north = "θ",
        northwest = "U",
    },
    _u_el = {
        "θ",
        north = "Θ",
        northwest = "u",
        west = "ϑ", -- Greek theta symbol
    },
    _V_el = {
        "Ω",
        northeast = "Ὠ",
        northwest = "Ὡ",
        north = "ω",
        east = "Ώ",
        south = "ῼ",
        west = "Ὼ",
        southeast = "Ὤ",
        southwest = "Ὥ",
        "Ὧ",
        "ᾯ",
        "Ὦ",
    },
    _v_el = {
        "ω",
        northeast = "ὠ",
        north = "Ω",
        northwest = "ὡ",
        east = "ώ",
        west = "ὼ",
        south = "ῳ",
        southeast = "ὤ",
        southwest = "ὥ",
        "ὧ",
        "ῶ",
        "ὦ",
    },
    _W_el = {
        "·", -- Greek ano teleia
        alt_label = "ς",
        north = "ς",
        northeast = "Ϛ", -- Greek letter stigma
        northwest = "W",
        east = "ʹ", -- Greek numeral sign
        west = "͵", -- Greek lower numeral sign
        southwest = "Ϝ", -- Greek letter digamma
        south = "Ϟ", -- Greek letter koppa
        southeast = "Ϡ", -- Greek letter sampi
    },
    _w_el = {
        "ς",
        alt_label = "·",
        north = "·", -- Greek ano teleia
        northeast = "ϛ", -- Greek small letter stigma
        northwest = "w",
        east = "ʹ", -- Greek numeral sign
        west = "͵", -- Greek lower numeral sign
        southwest = "ϝ", -- Greek small letter digamma
        south = "ϟ", -- Greek small letter koppa
        southeast = "ϡ", -- Greek small letter sampi
    },
    _X_el = {
        "Χ",
        alt_label = "V",
        north = "χ",
        northwest = "X", -- Latin capital letter X
        northeast = "H", -- Latin capital letter H
        east = "V",
        west = "A", -- Latin capital letter A
    },
    _x_el = {
        "χ",
        alt_label = "v",
        north = "Χ",
        northwest = "x", -- Latin small letter X
        northeast = "h", -- Latin small letter h
        east = "v",
        west = "a", -- Latin small letter a
        southwest = "i",
        southeast = "y",
    },
    _Y_el = {
        "Υ",
        north = "υ",
        northwest = "Ὑ",
        northeast = "Ϋ",
        east = "Ύ",
        west = "Ὺ",
        south = "Ὗ",
        southeast = "Ὕ",
        southwest = "Ὓ",
        "Y", -- Latin capital letter Y
    },
    _y_el = {
        "υ",
        northeast = "ὐ",
        north = "Υ",
        northwest = "ὑ",
        east = "ύ",
        west = "ὺ",
        south = "ῧ",
        southeast = "ὔ",
        southwest = "ὕ",
        "ΰ",
        "ϋ",
        "ῦ",
    },
    _Z_el = {
        "Ζ",
        north = "ζ",
        northwest = "Z", -- Latin capital letter Z
    },
    _z_el = {
        "ζ",
        north = "Ζ",
        northwest = "z",
    },
  -- _1_ and _1p: numeric key 1 and its popup sibling (they have north swipe ups of each other, the rest is the same)
  -- _1n and _1s: numpad key 1 (layer 2), -- superscript key 1 (layer 2, shifted)
  _1_ = { "1", north = "!", alt_label = "!", northeast = "¡", south = "'", southeast = "¿", east = "?", },
  _1p = { "!", north = "1", alt_label = "1", northeast = "¡", south = "'", southeast = "¿", east = "?", },
  _1n = { "1", north = "¹", northeast = "⅑", northwest = "⅐", east = "⅙", west = "¼", south = "₁", southwest = "½", southeast = "⅓", "⅕", "⅛", "⅒", },
  _1s = { "¹", north = "1", northeast = "⅑", northwest = "⅐", east = "⅙", west = "¼", south = "₁", southwest = "½", southeast = "⅓", "⅕", "⅛", "⅒", },

  _2_ = { "2", north = "@", alt_label = "@", northeast = "~", northwest = "http://", east = "-", west = "https://", south = '"', southeast = "…", southwest = "/", },
  _2p = { "@", north = "2", alt_label = "2", northeast = "~", northwest = "http://", east = "-", west = "https://", south = '"', southeast = "…", southwest = "/", },
  _2n = { "2", north = "²", northeast = "⅖", east = "½", south = "₂", southeast = "⅔", }, -- numpad 2
  _2s = { "²", north = "2", northeast = "⅖", east = "½", south = "₂", southeast = "⅔", }, -- superscript 2

  _3_ = { "3", north = "#", alt_label = "#", northeast = "☑", northwest = "★", east = "☐", west = "•", south = "№", southeast = "☒", southwest = "☆", ":)", ":|", ":(", },
  _3p = { "#", north = "3", alt_label = "3", northeast = "☑", northwest = "★", east = "☐", west = "•", south = "№", southeast = "☒", southwest = "☆", ":)", ":|", ":(", },
  _3n = { "3", north = "³", northwest = "¾", east = "⅓", west = "⅗", southwest = "⅜", south = "₃", }, -- numpad 3
  _3s = { "³", north = "3", northwest = "¾", east = "⅓", west = "⅗", southwest = "⅜", south = "₃", }, -- superscript 3

  _4_ = { "4", north = "$", alt_label = "$", northeast = "₸", northwest = "¥",  east = "₽", west = "£", south = "€", southeast = "¢", southwest = "₪", "₹", "₿", "₺", },
  _4p = { "$", north = "4", alt_label = "4", northeast = "₸", northwest = "¥",  east = "₽", west = "£", south = "€", southeast = "¢", southwest = "₪", "₹", "₿", "₺", },
  _4n = { "4", north = "⁴", east = "¼", south = "₄", southeast = "⅘", }, -- numpad 4
  _4s = { "⁴", north = "4", east = "¼", south = "₄", southeast = "⅘", }, -- superscript 4

  _5_ = { "5", north = "%", alt_label = "%", northeast = "‱", northwest = "‰", east = "⅓", west = "¼", south = "½", southeast = "⅔", southwest = "¾", },
  _5p = { "%", north = "5", alt_label = "5", northeast = "‱", northwest = "‰", east = "⅓", west = "¼", south = "½", southeast = "⅔", southwest = "¾", },
  _5n = { "5", north = "⁵", northeast = "⅚", east = "⅕", south = "₅", southeast = "⅝", }, -- numpad 5
  _5s = { "⁵", north = "5", northeast = "⅚", east = "⅕", south = "₅", southeast = "⅝", }, -- superscript 5

  -- diacritics. Symbols in quotation marks might look weird, however they should work fine.
  _6_ = {
  "6",
  north = "^",
  alt_label = "^",
  northeast = { label = "◌̈", key = "̈", }, -- Combining Diaeresis (Umlaut)
  northwest = { label = "◌̈́", key = "̈́", }, -- Combining Greek Dialytika Tonos
  east = { label = "◌́", key = "́", }, -- Combining Acute Accent
  west = { label = "◌̀", key = "̀", }, -- Combinig Grave Accent
  south = { label = "◌ͅ", key = "ͅ", }, -- Combining Greek Ypogegrammeni
  southeast = { label = "◌̄", key = "̄", }, -- Combining Macron
  southwest = { label = "◌̆", key = "̆", }, -- Combining Breve
  { label = "◌̓", key = "̓", }, -- Combining Greek Koronis
  { label = "◌͂", key = "͂", }, -- Combining Greek Perispomeni
  },
  _6p = {
  "^",
  north = "6",
  alt_label = "6",
  northeast = { label = "◌̈", key = "̈", }, -- Combining Diaeresis (Umlaut)
  northwest = { label = "◌̈́", key = "̈́", }, -- Combining Greek Dialytika Tonos
  east = { label = "◌́", key = "́", }, -- Combining Acute Accent
  west = { label = "◌̀", key = "̀", }, -- Combinig Grave Accent
  south = { label = "◌ͅ", key = "ͅ", }, -- Combining Greek Ypogegrammeni
  southeast = { label = "◌̄", key = "̄", }, -- Combining Macron
  southwest = { label = "◌̆", key = "̆", }, -- Combining Breve
  { label = "◌̓", key = "̓", }, -- Combining Greek Koronis
  { label = "◌͂", key = "͂", }, -- Combining Greek Perispomeni
  },
  _6n = { "6", north = "⁶", east = "⅙", south = "₆", }, -- numpad 6
  _6s = { "⁶", north = "6", east = "⅙", south = "₆", }, -- superscript 6

  _7_ = { "7", north = "&", alt_label = "&", northeast = "»", northwest = "«", east = "¶", west = "§", south = "¤", southeast = "⟩", southwest = "⟨", "†", "■", "‡", },
  _7p = { "&", north = "7", alt_label = "7", northeast = "»", northwest = "«", east = "¶", west = "§", south = "¤", southeast = "⟩", southwest = "⟨", "†", "■", "‡", },
  _7n = { "7", north = "⁷", east = "⅐", south = "₇", southeast = "⅞", }, -- numpad 7
  _7s = { "⁷", north = "7", east = "⅐", south = "₇", southeast = "⅞", }, -- superscript 7

  _8_ = { "8", north = "*", alt_label = "*", northeast = "=", northwest = "≠", east = "+", west = "-", south = "/", southeast = ">", southwest = "<", "≤", "≈", "≥", },
  _8p = { "*", north = "8", alt_label = "8", northeast = "=", northwest = "≠", east = "+", west = "-", south = "/", southeast = ">", southwest = "<", "≤", "≈", "≥", },
  _8n = { "8", north = "⁸", east = "⅛", south = "₈", }, -- numpad 8
  _8s = { "⁸", north = "8", east = "⅛", south = "₈", }, -- superscript 8

  _9_ = { "9", north = "(", alt_label = "(", northeast = "_", northwest = "“", east = "-", west = "{", south = "[", southeast = "—", southwest = "‘", },
  _9p = { "(", north = "9", alt_label = "9", northeast = "_", northwest = "“", east = "-", west = "{", south = "[", southeast = "—", southwest = "‘", },
  _9n = { "9", north = "⁹", east = "⅑", south = "₉", }, -- numpad 9
  _9s = { "⁹", north = "9", east = "⅑", south = "₉", }, -- superscript 9

  _0_ = { "0", north = ")", alt_label = ")", northwest = "”", west = "}", south = "]", southwest = "’", },
  _0p = { ")", north = "0", alt_label = "0", northwest = "”", west = "}", south = "]", southwest = "’", },
  _0n = { "0", north = "⁰", south = "₀", }, -- numpad 0
  _0s = { "⁰", north = "0", south = "₀", }, -- superscript 0

  sla = { "/", north = "÷", alt_label = "÷", northeast = "⅟", east = "⁄", }, -- numpad slash
  sl2 = { "÷", north = "/", alt_label = "/", northeast = "⅟", east = "⁄", }, -- superscript slash

  eql = { "=", north = "≠", alt_label = "≠", northwest = "≃",  west = "≡", south = "≈", southwest = "≉", }, -- equality
  eq2 = { "≠", north = "=", alt_label = "=", northwest = "≃", west = "≡", south = "≈", southwest = "≉", },  -- popup sibling
  ls1 = { "<", north = "≤", alt_label = "≤", south = "≪", }, -- "less than" sign
  ls2 = { "≤", north = "<", alt_label = "<", south = "≪", }, -- (popup sibling)
  mr1 = { ">", north = "≥", alt_label = "≥", south = "≫", }, -- "more than"
  mr2 = { "≥", north = ">", alt_label = ">", south = "≫", }, -- (popup sibling)
  pls = { "+", north = "±", alt_label = "±", }, -- plus sign
  pl2 = { "±", north = "+", alt_label = "+", }, -- (popup sibling)
  mns = { "-", north = "∓", alt_label = "∓", }, -- minus sign
  mn2 = { "∓", north = "-", alt_label = "-", }, -- (popup sibling)
  dsh = { "-", north = "—", alt_label = "—", south = "–", }, -- dashes
  dgr = { "†", north = "‡", alt_label = "‡", }, -- dagger
  tpg = { "¶", north = "§", alt_label = "§", northeast = "™", northwest = "℠", east = "¤", west = "•", south = "®", southeast = "🄯", southwest = "©", }, -- typography symbols
  mth = { "∇", north = "∀",alt_label = "∀",  northeast = "∃", northwest = "∄", east = "∈", west = "∉", south = "∅", southeast = "∩", southwest = "∪", "⊆", "⊂", "⊄", }, -- math operations 1
  mt2 = { "∞", north = "ℕ", alt_label = "ℕ", northeast = "ℤ", northwest = "ℚ", east = "𝔸", west = "ℝ", south = "𝕀", southeast = "ℂ", southwest = "𝕌", "⊇", "⊃", "⊅", }, -- math operations 2
  int = { "∫", north = "∬", alt_label = "∬", northeast = "⨌", northwest = "∭", east = "∑", west = "∏", south = "∮", southeast = "∰", southwest = "∯", "⊕", "ℍ", "⊗", }, -- integrals
  dif = { "∂", north = "√", alt_label = "√", northeast = "∴", east = "⇒", south = "⇔", southeast = "∵", }, -- math operations 3
  df2 = { "…", north = "⟂", alt_label = "⟂", northeast = "∡", northwest = "∟", east = "∝", west = "ℓ", }, -- math operations 4
  pdc = { "*", north = "⨯", alt_label = "⨯", south = "⋅", }, -- asterisk, cross-product and dot-prodcuts symbols
  pd2 = { "⨯", north = "*", alt_label = "*", south = "⋅", },
  bar = { "|", north = "¦", alt_label = "¦", }, -- bars like pipe and broken bar
  prm = { "‰", north = "‱", alt_label = "‱", }, -- per mile types
  hsh = { "#", north = "№", alt_label = "№", }, -- hash and "No." sign
  hs2 = { "№", north = "#", alt_label = "#", },
}
