local ffi = require("ffi")

ffi.cdef[[
typedef struct _zctx_t zctx_t;
typedef struct _zmsg_t zmsg_t;
typedef struct _zhash_t zhash_t;
typedef struct _zsock_t zsock_t;
typedef struct _zframe_t zframe_t;
typedef struct _zpoller_t zpoller_t;
static const int ZMQ_PAIR = 0;
static const int ZMQ_PUB = 1;
static const int ZMQ_SUB = 2;
static const int ZMQ_REQ = 3;
static const int ZMQ_REP = 4;
static const int ZMQ_DEALER = 5;
static const int ZMQ_ROUTER = 6;
static const int ZMQ_PULL = 7;
static const int ZMQ_PUSH = 8;
static const int ZMQ_XPUB = 9;
static const int ZMQ_XSUB = 10;
static const int ZMQ_STREAM = 11;
static const int ZMQ_AFFINITY = 4;
static const int ZMQ_IDENTITY = 5;
static const int ZMQ_SUBSCRIBE = 6;
static const int ZMQ_UNSUBSCRIBE = 7;
static const int ZMQ_RATE = 8;
static const int ZMQ_RECOVERY_IVL = 9;
static const int ZMQ_SNDBUF = 11;
static const int ZMQ_RCVBUF = 12;
static const int ZMQ_RCVMORE = 13;
static const int ZMQ_FD = 14;
static const int ZMQ_EVENTS = 15;
static const int ZMQ_TYPE = 16;
static const int ZMQ_LINGER = 17;
static const int ZMQ_RECONNECT_IVL = 18;
static const int ZMQ_BACKLOG = 19;
static const int ZMQ_RECONNECT_IVL_MAX = 21;
static const int ZMQ_MAXMSGSIZE = 22;
static const int ZMQ_SNDHWM = 23;
static const int ZMQ_RCVHWM = 24;
static const int ZMQ_MULTICAST_HOPS = 25;
static const int ZMQ_RCVTIMEO = 27;
static const int ZMQ_SNDTIMEO = 28;
static const int ZMQ_LAST_ENDPOINT = 32;
static const int ZMQ_ROUTER_MANDATORY = 33;
static const int ZMQ_TCP_KEEPALIVE = 34;
static const int ZMQ_TCP_KEEPALIVE_CNT = 35;
static const int ZMQ_TCP_KEEPALIVE_IDLE = 36;
static const int ZMQ_TCP_KEEPALIVE_INTVL = 37;
static const int ZMQ_TCP_ACCEPT_FILTER = 38;
static const int ZMQ_IMMEDIATE = 39;
static const int ZMQ_XPUB_VERBOSE = 40;
static const int ZMQ_ROUTER_RAW = 41;
static const int ZMQ_IPV6 = 42;
static const int ZMQ_MECHANISM = 43;
static const int ZMQ_PLAIN_SERVER = 44;
static const int ZMQ_PLAIN_USERNAME = 45;
static const int ZMQ_PLAIN_PASSWORD = 46;
static const int ZMQ_CURVE_SERVER = 47;
static const int ZMQ_CURVE_PUBLICKEY = 48;
static const int ZMQ_CURVE_SECRETKEY = 49;
static const int ZMQ_CURVE_SERVERKEY = 50;
static const int ZMQ_PROBE_ROUTER = 51;
static const int ZMQ_REQ_CORRELATE = 52;
static const int ZMQ_REQ_RELAXED = 53;
static const int ZMQ_CONFLATE = 54;
static const int ZMQ_ZAP_DOMAIN = 55;
static const int ZMQ_ROUTER_HANDOVER = 56;
static const int ZMQ_TOS = 57;
static const int ZMQ_IPC_FILTER_PID = 58;
static const int ZMQ_IPC_FILTER_UID = 59;
static const int ZMQ_IPC_FILTER_GID = 60;
static const int ZMQ_CONNECT_RID = 61;
static const int ZMQ_GSSAPI_SERVER = 62;
static const int ZMQ_GSSAPI_PRINCIPAL = 63;
static const int ZMQ_GSSAPI_SERVICE_PRINCIPAL = 64;
static const int ZMQ_GSSAPI_PLAINTEXT = 65;
static const int ZMQ_HANDSHAKE_IVL = 66;
static const int ZMQ_IDENTITY_FD = 67;
static const int ZFRAME_MORE = 1;
static const int ZFRAME_REUSE = 2;
int zmq_getsockopt(void *, int, void *, size_t *) __attribute__((visibility("default")));
int zmq_send(void *, void *, size_t, int);
zctx_t *zctx_new(void);
void zctx_destroy(zctx_t **);
void *zsocket_new(zctx_t *, int);
int zsocket_connect(void *, const char *, ...);
int zsocket_bind(void *, const char *, ...);
void zsocket_set_identity(void *, const char *);
char *zsocket_identity(void *);
void zsocket_destroy(zctx_t *, void *);
zframe_t *zframe_recv(void *);
size_t zframe_size(zframe_t *);
unsigned char *zframe_data(zframe_t *);
int zframe_send(zframe_t **, void *, int);
void zframe_destroy(zframe_t **);
zmsg_t *zmsg_new(void);
size_t zmsg_size(zmsg_t *);
int zmsg_addmem(zmsg_t *, const void *, size_t);
int zmsg_send(zmsg_t **, void *);
char *zmsg_popstr(zmsg_t *);
zframe_t *zmsg_pop(zmsg_t *);
void zmsg_destroy(zmsg_t **);
void zstr_free(char **);
int zstr_send (void *, const char *);
zhash_t *zhash_unpack(zframe_t *);
void *zhash_first(zhash_t *);
void *zhash_next(zhash_t *);
char *zhash_cursor(zhash_t *);
void *zhash_lookup(zhash_t *, const char *);
void zhash_destroy(zhash_t **);
zpoller_t *zpoller_new(void *, ...);
void zpoller_destroy(zpoller_t **);
int zpoller_add(zpoller_t *, void *);
void *zpoller_wait(zpoller_t *, int);
bool zpoller_expired(zpoller_t *);
bool zpoller_terminated(zpoller_t *);
]]
