local ffi = require("ffi")

ffi.cdef[[
enum MencaFileStatus_e {
  kMencaNoStatus = 0,
  kMencaInCloud = 1,
  kMencaSyncing = 2,
  kMencaDownloaded = 3,
};
enum bt_service_e {
  BT_UNKNOWN = 0,
  BT_AUTH = 1,
  BT_OBEX = 2,
  BT_SECOND_SCREEN = 3,
};
enum bt_service_state_e {
  BT_SERVICE_ACTIVE = 0,
  BT_SERVICE_CANCEL = 1,
  BT_SERVICE_ERROR = 2,
};
enum obex_status_e {
  OBEX_UNKNOWN = 0,
  OBEX_ERROR = 1,
  OBEX_REQUEST_AUTH = 2,
  OBEX_REQUEST_AUTH_DONE = 3,
  OBEX_TRANSFERRING = 4,
  OBEX_DONE = 5,
};
enum PB_STATE_e {
  MP_STOPPED = 0,
  MP_REQUEST_FOR_PLAY = 1,
  MP_PLAYING = 2,
  MP_PAUSED = 3,
  MP_PREVTRACK = 4,
  MP_NEXTTRACK = 5,
  MP_TRACK_FINISHED = 6,
  MP_LOAD_FILE_AND_PAUSE = 7,
};
enum PB_TTS_STATE_e {
  TTS_STOPPED = 0,
  TTS_PLAYING = 1,
  TTS_PAUSED = 2,
};
enum COVERCACHE_STORAGES_e {
  CCS_NONE = 0,
  CCS_ADOBE = 1,
  CCS_FBREADER = 2,
  CCS_DJVIEWER = 3,
  CCS_MAXSTORAGE = 4,
};
enum input_dev_e {
  UNKNOWN = 0,
  CAPTOUCH = 1,
  DIGITIZER = 2,
  MAX_INPUT_DEV = 3,
};
enum estyle {
  ROUND_ALL = 1,
  ROUND_TOP = 2,
  ROUND_DOWN = 3,
  ROUND_LEFT = 4,
  ROUND_RIGHT = 5,
  ROUND_TOP_LEFT = 6,
  ROUND_TOP_RIGHT = 7,
  ROUND_BOTTOM_LEFT = 8,
  ROUND_BOTTOM_RIGHT = 9,
};
typedef enum {
  SFLAGS_NONE = 0,
  SFLAGS_LEFT = 1,
  SFLAGS_RIGHT = 2,
  SFLAGS_RIGHT_LEFT = 3,
  SFLAGS_UP = 4,
  SFLAGS_UP_LEFT = 5,
  SFLAGS_UP_RIGHT = 6,
  SFLAGS_UP_RIGHT_LEFT = 7,
  SFLAGS_DOWN = 8,
  SFLAGS_DOWN_LEFT = 9,
  SFLAGS_DOWN_RIGHT = 10,
  SFLAGS_DOWN_RIGHT_LEFT = 11,
  SFLAGS_DOWN_UP = 12,
  SFLAGS_DOWN_UP_LEFT = 13,
  SFLAGS_DOWN_UP_RIGHT = 14,
  SFLAGS_ALL = 15,
} SideFlags;
typedef enum {
  PANEL_DISABLED = 0,
  PANEL_ENABLED = 2,
  PANEL_EVENT_NO_HANDLING = 4,
} PANEL_FLAGS;
typedef enum {
  FONT_STD = 0,
  FONT_BOLD = 1,
  FONT_ITALIC = 2,
  FONT_BOLDITALIC = 3,
  FONT_MONO = 4,
} FONT_TYPE;
typedef enum {
  STYLE_UNKNOWN = 0,
  STYLE_KEYBOARD = 1,
  STYLE_TOUCHPANEL = 2,
  STYLE_TOUCHPANEL_KEYBORAD = 3,
  STYLE_MAX_NOT_USED = 4,
} AppStyles;
typedef enum {
  APPLICATION_READER = 0,
  APPLICATION_ATTRIBUTE_MAX = 31,
} APPLICATION_ATTRIBUTE;
typedef enum {
  NET_STATE_UNKNOWN = -1,
  DISCONNECTED = 0,
  CONNECTING = 1,
  CONNECTED = 2,
} NET_STATE;
typedef enum {
  NO = 0,
  WEP = 1,
  WPAEAP = 2,
  WPAPSK = 3,
} WIFI_SECURITY;
typedef struct iv_wlist_s *(*pointer_to_word_hand_t)(int, int, int);
typedef union {
  char intr[8];
  char addr[16];
  char hw_addr[18];
} network_interface;
typedef struct {
  network_interface ip_addr;
  network_interface mask;
  network_interface br_addr;
  network_interface hw_addr;
} network_interface_info;
typedef char proxy_settings;
typedef enum {
  kBTInfo = 0,
  kBTAttention = 1,
  kBTWarning = 2,
  kBTQuestion = 3,
  kBTButton = 4,
} eBubbleTypes;
typedef enum {
  FM_SHOW_SIZE = 1,
} FONT_MENU_FLAGS;
typedef void (*iv_timerproc)();
typedef int (*iv_handler)(int, int, int);
typedef void (*iv_menuhandler)(int);
typedef void (*iv_hashdelproc)(void *);
typedef void (*iv_timerprocEx)(void *);
typedef void (*iv_keyboardhandler)(char *);
typedef void (*iv_dialoghandler)(int);
typedef void (*iv_timeedithandler)(long int);
typedef void (*iv_fontselecthandler)(char *, char *, char *, char *);
typedef void (*iv_dirselecthandler)(char *);
typedef void (*iv_confighandler)();
typedef void (*iv_itemchangehandler)(char *);
typedef void (*iv_pageselecthandler)(int);
typedef void (*iv_bmkhandler)(int, int, long long int);
typedef void (*iv_tochandler)(long long int);
typedef void (*iv_itempaint)(int, int, int, int);
typedef int (*iv_listhandler)(int, int, int, int, int);
typedef void (*iv_rotatehandler)(int);
typedef int (*iv_turnproc)(int);
typedef int (*iv_recurser)(char *, int, void *);
typedef int (*iv_msghandler)(int, void *, int);
typedef int (*iv_requestlistener)(int, void *, int, int);
typedef int (*iv_hashenumproc)(char *, void *, void *);
typedef int (*iv_hashcmpproc)(char *, void *, char *, void *);
typedef void (*iv_panelupdateshandler)(int, int, int, int);
typedef void (*iv_custombubbledraw)(struct icustombubble_s *);
typedef void (*iv_customherodraw)(struct icustomhero_s *);
struct BookSyncStatus_s {
  enum MencaFileStatus_e menca_status_;
};
struct iprofile_s {
  char *name;
  char *path;
  int type;
  struct ibitmap_s *avatar;
};
struct iprofiles_s {
  struct iprofile_s *profile;
  int count;
};
struct FontForSort_s {
  char *name;
  int flags;
  char *font;
};
struct obex_service_s {
  enum obex_status_e status;
  int auth;
  long int filesize;
  long int transferred;
  char name[128];
  char path[256];
  char description[128];
  char mimetype[64];
};
struct bt_service_obj_s {
  int id;
  enum bt_service_e service;
  enum bt_service_state_e state;
  int lock;
  int users[16];
  union {
    struct obex_service_s obex;
    char service_data[1024];
  };
};
struct iuser_font_s {
  char *show_font_name;
  char *real_font_name;
  struct ifont_s *font;
};
struct ifont_list_s {
  struct iuser_font_s *list;
  int count;
};
struct ifont_menu_s {
  char *menu_title;
  char *current_font;
  FONT_MENU_FLAGS flags;
  iv_fontselecthandler hproc;
  struct ifont_list_s *user_fonts;
};
struct irect_s {
  int x;
  int y;
  int w;
  int h;
  int flags;
};
struct ibitmap_s {
  short unsigned int width;
  short unsigned int height;
  short unsigned int depth;
  short unsigned int scanline;
  unsigned char data[0];
};
struct control_panel_s {
  int flags;
};
struct TransparentDefinition {
  char m_TRANSPARENT_MATRIX[256];
  int m_isInitTransparentMatrix;
  int m_PercentOfTransparent;
};
struct ihash_item_s {
  char *name;
  void *value;
  struct ihash_item_s *next;
};
struct ihash_s {
  int prime;
  int count;
  void *(*addproc)(void *);
  iv_hashdelproc delproc;
  struct ihash_item_s **items;
};
struct ifont_s {
  char *name;
  char *family;
  int size;
  unsigned char aa;
  unsigned char isbold;
  unsigned char isitalic;
  unsigned char _r1;
  short unsigned int charset;
  short unsigned int _r2;
  int color;
  int height;
  int linespacing;
  int baseline;
  void *fdata;
};
struct imenu_s {
  short int type;
  short int index;
  char *text;
  struct imenu_s *submenu;
};
struct imenuex_s {
  short int type;
  short int index;
  char *text;
  struct imenuex_s *submenu;
  struct ibitmap_s *icon;
  void *reserved;
  const struct ifont_s *font;
};
struct icanvas_s {
  int width;
  int height;
  int scanline;
  int depth;
  int clipx1;
  int clipx2;
  int clipy1;
  int clipy2;
  unsigned char *addr;
};
struct icontext_menu_properties_s {
  struct ifont_s *font_normal;
  struct ifont_s *font_selected;
  struct ifont_s *font_disabled;
  int background_color_normal;
  int background_color_disabled;
  int blackout;
  int item_height;
  int item_border_indent_horizontal;
  int separator_indent_horizontal;
  int separator_indent_vertical;
  int separator_height;
  int separator_style;
  int separator_color;
  int separator_frequency;
  int marker_height;
  int marker_indent_horizontal;
  int marker_style;
  int marker_color;
  int border_size;
  int border_radius;
  int title_height;
  int enable_pointer;
  int font_normal_color;
  int font_selected_color;
  int font_disabled_color;
  int bullet_show;
  int bullet_style;
  int item_border_indent_vertical;
  int background_style;
};
struct ifont_selector_properties {
  short unsigned int custom_font_enable;
};
struct icontext_menu_s {
  const char *id;
  iv_menuhandler hproc;
  const struct imenuex_s *menuex;
  const struct imenu_s *menu;
  struct irect_s pos_selected_item;
  struct irect_s pos_menu;
  struct icontext_menu_properties_s *properties;
  int active_element;
  short int enable_pointer;
  short int enable_aura;
  short int use_own_font;
  short int update_after_close;
  short int only_choise;
};
struct iapp_caption_s {
  struct irect_s rect_portrait;
  struct irect_s rect_landscape;
  struct ifont_s *font;
  int title_height;
  int background_color;
  short int is_active;
  short int is_uppercase;
};
struct itaskmgr_s {
  int title_height;
  struct ifont_s *title_font;
  struct ifont_s *task_font;
  struct ifont_s *task_title_font;
  int style;
  int profile_present;
  int profile_height;
  struct ifont_s *profile_font;
  int shortcut_height;
  int shortcut_width;
  struct ifont_s *shortcut_font;
  int task_height;
  int full_height;
  int full_width;
  int width;
  int height;
  int x;
  int y;
  int border_size;
  int indent_from_border;
  struct ibitmap_s **bitmap;
  int bitmap_count;
  int separator_size;
  int exit_button_indent;
  int background_style;
  int separator_color;
  int border_color;
};
struct ipager_s {
  struct ifont_s *page_font;
  int height;
  int indent_horizontal;
  int left_width;
  int page_width;
  int rigth_width;
  int separator_size;
  const struct ibitmap_s *icon_left;
  const struct ibitmap_s *icon_right;
  int current_page;
  int total_pages;
  struct irect_s position;
  int orientation;
};
struct iselection_s {
  int selection_style;
  int background_color;
  int background_style;
  int border_size;
  int border_radius;
  int indent_horizontal;
  int indent_left;
  int indent_right;
};
struct iappstyle_s {
  AppStyles app_style;
};
struct ievent_s {
  iv_handler hproc;
  short unsigned int type;
  short unsigned int mod;
  short unsigned int par1;
  short unsigned int par2;
};
struct iconfig_s {
  char *filename;
  struct ihash_s *hash;
  struct ihash_s *vhash;
  struct ihash_s *modified_hash;
  char **deleted_keys;
  int changed;
};
struct iconfigedit_s {
  int type;
  const struct ibitmap_s *icon;
  char *text;
  char *hint;
  char *name;
  char *deflt;
  char **variants;
  struct iconfigedit_s *submenu;
  struct ibitmap_s **icon_theme;
};
struct oldconfigedit_s {
  char *text;
  char *name;
  int type;
  char *deflt;
  char **variants;
};
struct tocentry_s {
  int level;
  int page;
  long long int position;
  char *text;
};
struct itimer_s {
  iv_timerproc tp;
  int weak;
  long long int extime;
  char name[32];
  void *context;
  long long int lastchecktime;
};
struct bookinfo_s {
  int type;
  char *typedesc;
  char *path;
  char *filename;
  char *title;
  char *author;
  char *series;
  int numinseries;
  char *genre[10];
  struct ibitmap_s *icon;
  int year;
  long int size;
  long int ctime;
  char *isbn;
  char *meta_id;
  char *first_author;
  int drm;
  char *annotation;
  char *lang;
  char *publisher;
  char *identifiers;
};
struct iv_filetype_s {
  char *extension;
  char *description;
  int type;
  char *program;
  struct ibitmap_s *icon;
};
struct iv_template_s {
  int width;
  int height;
  struct ibitmap_s *background;
  struct ibitmap_s *bg_folder;
  struct ibitmap_s *bg_folder_a;
  struct ibitmap_s *bg_file;
  struct ibitmap_s *bg_file_a;
  struct irect_s iconpos;
  struct irect_s mediaiconpos;
  struct irect_s line1pos;
  struct irect_s line2pos;
  struct irect_s line3pos;
  struct ifont_s *line1font;
  struct ifont_s *line2font;
  struct ifont_s *line3font;
};
struct iv_wlist_s {
  char *word;
  short int x1;
  short int y1;
  short int x2;
  short int y2;
};
struct iv_netinfo_s {
  int connected;
  char name[64];
  char device[64];
  char security[64];
  char prefix[64];
  int index;
  int atime;
  int speed;
  int reserved_0e;
  long unsigned int bytes_in;
  long unsigned int bytes_out;
  long unsigned int packets_in;
  long unsigned int packets_out;
};
struct iv_sessioninfo_s {
  char *url;
  char *ctype;
  long int response;
  int length;
  int progress;
};
struct iv_fbinfo_s {
  int version;
  unsigned int flags;
  int shmkey;
  int shmsize;
  int refkey;
  int refsize;
  int width;
  int height;
  int vdepth;
  int ndepth;
  int orientation;
  int _deprecated_cwidth;
  int _deprecated_cheight;
  int scanline;
  int fb_offset;
  int fb_size;
  int ev_offset;
  int ev_size;
  int evhead;
  int evtail;
  int einkversion;
  int reserved[15];
  unsigned char data[0];
  int fb_y_offset;
};
struct subtaskinfo_s {
  int id;
  char *name;
  char *book;
  int fgindex;
  int order;
  int rsv_1s;
};
struct taskinfo_s {
  int task;
  int nsubtasks;
  unsigned int flags;
  int fbshmkey;
  int fbshmsize;
  int mainpid;
  char *appname;
  struct ibitmap_s *icon;
  struct subtaskinfo_s *subtasks;
  int rsv_1;
  int rsv_2;
  int rsv_3;
  int rsv_4;
};
struct iv_mtinfo_s {
  int active;
  int x;
  int y;
  int pressure;
  enum input_dev_e devtype;
  int rsv_2;
  long long int timems;
};
struct apinfo_s {
  char ssid[36];
  int mode;
  int channel;
  WIFI_SECURITY security;
  int quality;
  int level;
  int noise;
  unsigned char mac[8];
  long int timestamp;
};
struct wifi_ap_list_s {
  int ap_quantity;
  struct apinfo_s apinfo[];
};
struct network_interface_array_s {
  unsigned int count;
  network_interface net_int[];
};
struct icolor_map_s {
  int *from_color;
  int *to_color;
  int size;
};
struct icustombubble_s {
  int type;
  struct irect_s bubble_pos;
  struct irect_s arrow_pos;
  struct ibitmap_s *arrow_bmp;
  struct ibitmap_s *icon_bmp;
  struct irect_s text_pos;
  struct ifont_s *font;
  char *text;
};
struct icustomhero_s {
  struct irect_s pos;
  char *name;
  struct ibitmap_s *hero_bmp;
  int max_bubbles;
  struct irect_s **bubbles;
};
struct icustomdialog_s {
  int timeout;
  int bubble_count;
  struct icustombubble_s **bubbles;
  struct icustomhero_s *hero;
  iv_customherodraw hero_draw;
  iv_custombubbledraw bubble_draw;
  iv_dialoghandler cb_handler;
  int cancel_enable_;
};
static const int MAX_BT_SERVICE_USER = 16;
static const int MSG_ACTUALIZEFRONTLIGHT = 284;
static const int MSG_UPDATE_SERVICE_STATUSES = 285;
static const int MSG_FACTORY_RESET = 286;
static const int MSG_SETTIME_FROM_NTP = 287;
static const int MSG_GET_IS_TIME_MONOTONIC_AFTER_LAST_NTP_SYNC = 288;
static const int MSG_GET_PARTNER_ID = 289;
static const int MSG_UPDATE_PARTNER_ID = 290;
static const int MSG_BAN_SUSPEND = 291;
static const int MSG_BACKUP = 292;
static const int MSG_RESTORE = 293;
static const int MSG_TASK_SEND_REQUEST_NOWAIT = 1303;
static const int MSG_START_SERVICES = 1536;
static const int MSG_LAST_OPEN_OPENED = 1537;
static const int APP_UID = 101;
static const int APP_GID = 101;
static const int SECAPP_UID = 102;
static const int SECAPP_GID = 102;
static const int SYSTEMDEPTH = 8;
static const int MAXMSGSIZE = 65520;
static const int MSG_REQUEST = 2147483647;
static const int MSG_XREQUEST = 2080374784;
static const int MSG_OK = 1;
static const int MSG_ERROR = 0;
static const int MSG_FORMAT = 257;
static const int MSG_SETTIME = 258;
static const int MSG_SETPROFILE = 259;
static const int MSG_PWENCRYPT = 260;
static const int MSG_PWDECRYPT = 261;
static const int MSG_RESTART = 262;
static const int MSG_REMOUNTFS = 263;
static const int MSG_WRITELOGO = 264;
static const int MSG_RESTORELOGO = 265;
static const int MSG_SUSPEND = 266;
static const int MSG_IOC_ENCRYPT = 267;
static const int MSG_IOC_DECRYPT = 268;
static const int MSG_REG_CHECK = 269;
static const int MSG_REG_WRITE = 270;
static const int MSG_GETSERIAL = 271;
static const int MSG_REBOOT = 272;
static const int MSG_REBOOT_AND_UPDATE = 273;
static const int MSG_TIMESTAMP = 274;
static const int MSG_UPDATESTATUS = 275;
static const int MSG_DISABLE_GSENSOR = 276;
static const int MSG_ENABLE_GSENSOR = 277;
static const int MSG_CONFIG_CHANGED = 278;
static const int MSG_SET_LED = 279;
static const int MSG_ENCRYPT_MEM = 280;
static const int MSG_DECRYPT_MEM = 281;
static const int MSG_GETDEVICEID = 282;
static const int MSG_SETFRONTLIGHT = 283;
static const int MSG_FBINFO = 513;
static const int MSG_ORIENTATION = 514;
static const int MSG_UPDPARTIAL = 515;
static const int MSG_UPDDYNAMIC = 516;
static const int MSG_UPDFULL = 517;
static const int MSG_EINKPM = 518;
static const int MSG_EINKTEMP = 519;
static const int MSG_TASK_REGISTER = 1281;
static const int MSG_TASK_NEWSUBTASK = 1282;
static const int MSG_TASK_SWITCHSUBTASK = 1283;
static const int MSG_TASK_ENDSUBTASK = 1284;
static const int MSG_TASK_SETPARAMETERS = 1285;
static const int MSG_TASK_SETSUBTASKINFO = 1286;
static const int MSG_TASK_FOREGROUND = 1287;
static const int MSG_TASK_BACKGROUND = 1288;
static const int MSG_TASK_CLOSE = 1289;
static const int MSG_TASK_LIST = 1290;
static const int MSG_TASK_PREVIOUS = 1291;
static const int MSG_TASK_INFO = 1292;
static const int MSG_TASK_SENDEVENT = 1293;
static const int MSG_TASK_SENDREQUEST = 1294;
static const int MSG_TASK_ADDREQLISTENER = 1296;
static const int MSG_TASK_DELREQLISTENER = 1297;
static const int MSG_TASK_GLOBALREQUEST = 1298;
static const int MSG_TASK_SENDEVENTSYNC = 1299;
static const int MSG_TASK_INITIALIZED = 1300;
static const int MSG_TASK_PREVIOUS_INSTACK = 1301;
static const int MSG_TASK_COPY_ACTIVE_FB = 1302;
static const int MSG_DEVICEKEY = 181452289;
static const int MSG_RESETKEY = 181452290;
static const int EVT_INIT = 21;
static const int EVT_EXIT = 22;
static const int EVT_SHOW = 23;
static const int EVT_REPAINT = 43;
static const int EVT_HIDE = 24;
static const int EVT_KEYDOWN = 25;
static const int EVT_KEYPRESS = 25;
static const int EVT_KEYUP = 26;
static const int EVT_KEYRELEASE = 26;
static const int EVT_KEYREPEAT = 28;
static const int EVT_POINTERUP = 29;
static const int EVT_POINTERDOWN = 30;
static const int EVT_POINTERMOVE = 31;
static const int EVT_POINTERLONG = 34;
static const int EVT_POINTERHOLD = 35;
static const int EVT_POINTERDRAG = 44;
static const int EVT_POINTERCANCEL = 45;
static const int EVT_ORIENTATION = 32;
static const int EVT_FOCUS = 36;
static const int EVT_UNFOCUS = 37;
static const int EVT_ACTIVATE = 38;
static const int EVT_MTSYNC = 39;
static const int EVT_TOUCHUP = 40;
static const int EVT_TOUCHDOWN = 41;
static const int EVT_TOUCHMOVE = 42;
static const int EVT_QN_MOVE = 51;
static const int EVT_QN_RELEASE = 52;
static const int EVT_QN_BORDER = 53;
static const int EVT_SNAPSHOT = 71;
static const int EVT_FSINCOMING = 72;
static const int EVT_FSCHANGED = 73;
static const int EVT_MP_STATECHANGED = 81;
static const int EVT_MP_TRACKCHANGED = 82;
static const int EVT_PREVPAGE = 91;
static const int EVT_NEXTPAGE = 92;
static const int EVT_OPENDIC = 93;
static const int EVT_CONTROL_PANEL_ABOUT_TO_OPEN = 94;
static const int EVT_PANEL_BLUETOOTH_A2DP = 118;
static const int EVT_TAB = 119;
static const int EVT_PANEL = 120;
static const int EVT_PANEL_ICON = 121;
static const int EVT_PANEL_TEXT = 122;
static const int EVT_PANEL_PROGRESS = 123;
static const int EVT_PANEL_MPLAYER = 124;
static const int EVT_PANEL_USBDRIVE = 125;
static const int EVT_PANEL_NETWORK = 126;
static const int EVT_PANEL_CLOCK = 127;
static const int EVT_PANEL_BLUETOOTH = 128;
static const int EVT_PANEL_TASKLIST = 129;
static const int EVT_PANEL_OBREEY_SYNC = 130;
static const int EVT_PANEL_SETREADINGMODE = 131;
static const int EVT_PANEL_SETREADINGMODE_INVERT = 132;
static const int EVT_PANEL_FRONT_LIGHT = 133;
static const int EVT_GLOBALREQUEST = 149;
static const int EVT_GLOBALACTION = 150;
static const int EVT_FOREGROUND = 151;
static const int EVT_BACKGROUND = 152;
static const int EVT_SUBTASKCLOSE = 153;
static const int EVT_CONFIGCHANGED = 154;
static const int EVT_SAVESTATE = 155;
static const int EVT_OBREEY_CONFIG_CHANGED = 156;
static const int EVT_SDIN = 161;
static const int EVT_SDOUT = 162;
static const int EVT_BT_RXCOMPLETE = 171;
static const int EVT_BT_TXCOMPLETE = 172;
static const int EVT_SYNTH_ENDED = 200;
static const int EVT_DIC_CLOSED = 201;
static const int EVT_SHOW_KEYBOARD = 202;
static const int EVT_TEXTCLEAR = 209;
static const int EVT_EXT_KB = 210;
static const int EVT_LETTER = 211;
static const int EVT_CALLBACK = 212;
static const int EVT_SCANPROGRESS = 213;
static const int EVT_STOPSCAN = 214;
static const int EVT_STARTSCAN = 215;
static const int EVT_SCANSTOPPED = 216;
static const int EVT_POSTPONE_TIMED_POWEROFF = 217;
static const int EVT_FRAME_ACTIVATED = 218;
static const int EVT_FRAME_DEACTIVATED = 219;
static const int EVT_READ_PROGRESS_CHANGED = 220;
static const int EVT_DUMP_BITMAPS_DEBUG_INFO = 221;
static const int EVT_NET_CONNECTED = 256;
static const int EVT_NET_DISCONNECTED = 257;
static const int EVT_NET_FOUND_NEW_FW = 260;
static const int EVT_SYNTH_POSITION = 261;
static const int KEY_POWER = 1;
static const int KEY_DELETE = 8;
static const int KEY_OK = 10;
static const int KEY_UP = 17;
static const int KEY_DOWN = 18;
static const int KEY_LEFT = 19;
static const int KEY_RIGHT = 20;
static const int KEY_MINUS = 21;
static const int KEY_PLUS = 22;
static const int KEY_MENU = 23;
static const int KEY_PREV = 24;
static const int KEY_NEXT = 25;
static const int KEY_HOME = 26;
static const int KEY_BACK = 27;
static const int KEY_PREV2 = 28;
static const int KEY_NEXT2 = 29;
static const int KEY_MUSIC = 30;
static const int KEY_COVEROPEN = 2;
static const int KEY_COVERCLOSE = 3;
static const int KEY_ZOOMOUT = 6;
static const int KEY_ZOOMIN = 7;
static const int KEY_SHIFT = 14;
static const int KEY_LANGUAGECHANGE = 15;
static const int KEY_KEYBOARDCLOSE = 16;
static const int KEY_0 = 48;
static const int KEY_1 = 49;
static const int KEY_2 = 50;
static const int KEY_3 = 51;
static const int KEY_4 = 52;
static const int KEY_5 = 53;
static const int KEY_6 = 54;
static const int KEY_7 = 55;
static const int KEY_8 = 56;
static const int KEY_9 = 57;
static const int KEYMAPPING_GLOBAL = 0;
static const int KEYMAPPING_TXT = 1;
static const int KEYMAPPING_PDF = 2;
static const int BLACK = 0;
static const int DGRAY = 5592405;
static const int LGRAY = 11184810;
static const int WHITE = 16777215;
static const int ITEM_HEADER = 1;
static const int ITEM_ACTIVE = 2;
static const int ITEM_INACTIVE = 3;
static const int ITEM_SUBMENU = 5;
static const int ITEM_SEPARATOR = 6;
static const int ITEM_BULLET = 7;
static const int ITEM_TYPEMASK = 31;
static const int ITEM_HIDDEN = 128;
static const int ITEM_OLDMENU = 32768;
static const int ITEM_ALTSTYLE = 64;
static const int KBD_NORMAL = 0;
static const int KBD_ENTEXT = 1;
static const int KBD_PHONE = 2;
static const int KBD_NUMERIC = 4;
static const int KBD_IPADDR = 5;
static const int KBD_FILENAME = 6;
static const int KBD_URL = 7;
static const int KBD_DATE = 8;
static const int KBD_TIME = 9;
static const int KBD_DATETIME = 10;
static const int KBD_HEX = 11;
static const int KBD_HOURS = 12;
static const int KBD_UPPER = 16;
static const int KBD_LOWER = 32;
static const int KBD_FIRSTUPPER = 48;
static const int KBD_PASSWORD = 256;
static const int KBD_NOSELECT = 512;
static const int KBD_SCREENTOP = 1024;
static const int KBD_NOHEADER = 2048;
static const int KBD_NOEVTSHOW = 4096;
static const int KBD_SENDKEYBOARDSTATEEVENTS = 8192;
static const int KBD_NOTOUCH = 16384;
static const int KBD_PASSEVENTS = 32768;
static const int KBD_NOUPDATE_AFTER_CLOSE = 65536;
static const int KBD_EN_DEFAULT = 131072;
static const int KBD_NOUPDATE_AFTER_OPEN = 262144;
static const int KBD_NO_SELFCLOSE_ON_OK = 524288;
static const int KBD_CUSTOM_ENTER_KEY = 1048576;
static const int KBD_MARKED_ENTER_KEY = 2097152;
static const int KBD_PASSWORD_WIFI = 4194304;
static const int KBD_NEXT = 8388608;
static const int ICON_INFORMATION = 1;
static const int ICON_QUESTION = 2;
static const int ICON_WARNING = 3;
static const int ICON_ERROR = 4;
static const int ICON_WIFI = 5;
static const int DEF_BUTTON1 = 0;
static const int DEF_BUTTON2 = 4096;
static const int DEF_BUTTON3 = 8192;
static const int NO_DISMISS = 32768;
static const int WITH_SIZE = 1;
static const int LIST_BEGINPAINT = 1;
static const int LIST_PAINT = 2;
static const int LIST_ENDPAINT = 3;
static const int LIST_OPEN = 4;
static const int LIST_MENU = 5;
static const int LIST_DELETE = 6;
static const int LIST_EXIT = 7;
static const int LIST_ORIENTATION = 8;
static const int LIST_POINTER = 9;
static const int LIST_INFO = 11;
static const int LIST_SCROLL = 12;
static const int LISTFLAG_SCROLL = 1073741824;
static const int BMK_CLOSED = -1;
static const int BMK_SELECTED = 1;
static const int BMK_ADDED = 2;
static const int BMK_REMOVED = 3;
static const int BMK_PAINT = 4;
static const int CFG_TEXT = 1;
static const int CFG_CHOICE = 2;
static const int CFG_INDEX = 3;
static const int CFG_TIME = 4;
static const int CFG_FONT = 5;
static const int CFG_FONTFACE = 6;
static const int CFG_INFO = 7;
static const int CFG_NUMBER = 8;
static const int CFG_ENTEXT = 9;
static const int CFG_PASSWORD = 10;
static const int CFG_IPADDR = 11;
static const int CFG_URL = 12;
static const int CFG_PHONE = 13;
static const int CFG_ACTIONS = 14;
static const int CFG_CHOICE_SPECIAL_FONT = 15;
static const int CFG_DIRECTORY = 16;
static const int CFG_HOURS = 17;
static const int CFG_CHECKBOX = 18;
static const int CFG_SUBMENU_ACTION = 29;
static const int CFG_CUSTOM = 30;
static const int CFG_SUBMENU = 31;
static const int CFG_MASK = 127;
static const int CFG_HIDDEN = 128;
static const int CFG_READONLY = 256;
static const int CFG_BSCSPEC = 512;
static const int ALLTASKS = -1;
static const int MAINTASK = -2;
static const int OTHERTASKS = -3;
static const int THISTASK = -4;
static const int ACTIVETASK = -5;
static const int MPLAYERTASK = -6;
static const int DICTIONARYTASK = -7;
static const int ALLSUBTASKS = -1;
static const int CURRENTSUBTASK = -6;
static const int TASK_HIDDEN = 1;
static const int TASK_COPYLASTFB = 2;
static const int TASK_NOUPDATEONFOCUS = 4;
static const int TASK_SINGLEINSTANCE = 8;
static const int TASK_SPYEVENTS = 16;
static const int TASK_OUTOFSTACK = 32;
static const int TASK_NOFORCEDKILL = 64;
static const int TASK_MAKEACTIVE = 128;
static const int TASK_GROUP1 = 256;
static const int TASK_GROUP2 = 512;
static const int TASK_OOMPROOF = 16384;
static const int TASK_AUTORESTART = 32768;
static const int TASK_DONTSENDTASKMSG = 65536;
static const int TASK_DONTCHANGE = 4294967295;
static const int RQL_ADD = 1;
static const int RQL_REPLACE = 2;
static const int RQL_ADDIFNONE = 3;
static const int RQL_REMOVE = 4;
static const int REQ_KEYLOCK = 65;
static const int REQ_MAINMENU = 66;
static const int REQ_EXIT = 67;
static const int REQ_LASTOPEN = 68;
static const int REQ_PROFILES = 69;
static const int REQ_SCREENSHOT = 70;
static const int REQ_CALC = 71;
static const int REQ_PLAYER = 72;
static const int REQ_PLAYPAUSE = 73;
static const int REQ_VOLUMEUP = 74;
static const int REQ_VOLUMEDOWN = 75;
static const int REQ_NETWORK = 76;
static const int REQ_BTSWITCH = 77;
static const int REQ_DROPCONN = 78;
static const int REQ_TASKMGR = 79;
static const int REQ_SWITCHTASK = 80;
static const int REQ_FLIPTASK = 81;
static const int REQ_KILLTASK = 82;
static const int REQ_POWEROFF = 83;
static const int REQ_OPENBOOK = 84;
static const int REQ_BOOKSTATE = 85;
static const int REQ_BOOKOPENED = 86;
static const int REQ_HEADCHNG = 87;
static const int REQ_OPENBOOK2 = 88;
static const int REQ_FRONTLIGHT = 89;
static const int REQ_KEYUNLOCK = 90;
static const int REQ_HOURGLASS = 91;
static const int REQ_MESSAGEBOX = 92;
static const int REQ_KEYHARDLOCK = 93;
static const int REQ_PB_CLOUD_NEW_POSITION = 94;
static const int ALIGN_LEFT = 1;
static const int ALIGN_CENTER = 2;
static const int ALIGN_RIGHT = 4;
static const int ALIGN_FIT = 8;
static const int VALIGN_TOP = 16;
static const int VALIGN_MIDDLE = 32;
static const int VALIGN_BOTTOM = 64;
static const int ROTATE = 128;
static const int HYPHENS = 256;
static const int DOTS = 512;
static const int RTLAUTO = 1024;
static const int UNDERLINE = 2048;
static const int STRETCH = 4096;
static const int TILE = 8192;
static const int TO_UPPER = 16384;
static const int FR_CLOSE = 1;
static const int FR_MOVEUP = 2;
static const int FR_MOVEDOWN = 4;
static const int FR_DICTIONARY = 67108864;
static const int FR_NOMARGIN = 134217728;
static const int FR_OVERLAP = 268435456;
static const int FR_HEADER = 536870912;
static const int FR_UPDATE = 1073741824;
static const int FR_INFO = 65536;
static const int FR_WARNING = 131072;
static const int FR_ERROR = 196608;
static const int FR_DIALOG = 262144;
static const int FR_APP = 327680;
static const int ARROW_LEFT = 1;
static const int ARROW_RIGHT = 2;
static const int ARROW_UP = 3;
static const int ARROW_DOWN = 4;
static const int SYMBOL_OK = 5;
static const int SYMBOL_PAUSE = 6;
static const int SYMBOL_BULLET = 7;
static const int ARROW_UPDOWN = 8;
static const int SYMBOL_MENU = 9;
static const int IMAGE_BW = 1;
static const int IMAGE_GRAY2 = 2;
static const int IMAGE_GRAY4 = 4;
static const int IMAGE_GRAY8 = 8;
static const int IMAGE_RGB = 24;
static const int ROTATE0 = 0;
static const int ROTATE90 = 1;
static const int ROTATE270 = 2;
static const int ROTATE180 = 3;
static const int XMIRROR = 4;
static const int YMIRROR = 8;
static const int A2DITHER = 16;
static const int DITHER_THRESHOLD = 0;
static const int DITHER_PATTERN = 1;
static const int DITHER_DIFFUSION = 2;
static const int QN_X = 4096;
static const int QN_Y = 8192;
static const int QN_XY = 12288;
static const int QN_SWAIT = 16384;
static const int QN_RWAIT = 32768;
static const int QN_CLEANUP = 65536;
static const int MP_ONCE = 0;
static const int MP_CONTINUOUS = 1;
static const int MP_RANDOM = 2;
static const int FTYPE_UNKNOWN = 0;
static const int FTYPE_BOOK = 1;
static const int FTYPE_PICTURE = 2;
static const int FTYPE_MUSIC = 3;
static const int FTYPE_APPLICATION = 4;
static const int FTYPE_WEBLINK = 5;
static const int FTYPE_FOLDER = 255;
static const int OB_ADDTOLAST = 1;
static const int OB_WITHRETURN = 2;
static const int OB_PARAMSFIRST = 4;
static const int OB_NONEWTASK = 8;
static const int OB_SOFTUPDATE = 16;
static const int OB_NOHOURGLASS = 32;
static const int NET_BLUETOOTH = 1;
static const int NET_WIFI = 2;
static const int NET_CDMA3G = 4;
static const int NET_BTREADY = 256;
static const int NET_WIFIREADY = 512;
static const int NET_CDMA3GREADY = 1024;
static const int NET_CONNECTED = 3840;
static const int CONN_GPRS = 1;
static const int CONN_WIFI = 2;
static const int CONN_CDMA3G = 3;
static const int BLUETOOTH_OFF = 0;
static const int BLUETOOTH_HIDDEN = 1;
static const int BLUETOOTH_VISIBLE = 2;
static const int NET_OK = 0;
static const int NET_CONNECT = 1;
static const int NET_TRANSFER = 2;
static const int NET_FAIL = -11;
static const int NET_ABORTED = -12;
static const int NET_EINIT = -13;
static const int NET_EWRONGID = -14;
static const int NET_ENETWORK = -15;
static const int NET_EFILE = -16;
static const int NET_EPIPE = -17;
static const int NET_ETHREAD = -18;
static const int NET_EPROTO = -19;
static const int NET_EURL = -20;
static const int NET_ERESOLVE = -21;
static const int NET_ECONNECT = -22;
static const int NET_EACCESS = -23;
static const int NET_ENOTFOUND = -24;
static const int NET_EPARTIAL = -25;
static const int NET_EBROKEN = -26;
static const int NET_ETIMEOUT = -27;
static const int NET_ESERVER = -28;
static const int NET_EHTTP = -29;
static const int NET_EHARDWARE = -30;
static const int NET_ENOTCONF = -31;
static const int NET_EBADCONF = -32;
static const int NET_ENODEVICE = -33;
static const int NET_EPPP = -34;
static const int NET_EDISABLED = -35;
static const int NET_EDHCP = -36;
static const int NET_EWRONGKEY = -37;
static const int NET_EAUTH = -38;
static const int GSENSOR_OFF = 0;
static const int GSENSOR_ON = 1;
static const int GSENSOR_INTR = 2;
static const int VN_NOPATH = 1;
static const int VN_NOESCAPE = 2;
static const int VN_ABSOLUTE = 4;
static const int VN_RELATIVE = 8;
static const int A2DP_DISCONNECTED = 0;
static const int A2DP_CONNECTED_TO_SNK = 1;
static const int CF_CONFIG_RESUME = 1;
static const int FONT_ACTIVATE_CODE = 2410017735;
static const int IV_OSY_STATUS_TURNED_OFF = 0;
static const int IV_OSY_STATUS_WRONG_LOGIN_PASSWORD = 1;
static const int IV_OSY_STATUS_DOWNLOADING = 2;
static const int IV_OSY_STATUS_PAUSED = 3;
static const int IV_OSY_STATUS_IDLE = 4;
static const int IV_OSY_STATUS_ERROR = 5;
void InitInkview(int);
void CalibrateGSensor();
void CloseApp();
int GetGlobalOrientation();
int GetOrientation();
void InkViewMain(iv_handler);
struct irect_s iRect(int, int, int, int, int);
void OpenScreen();
void OpenScreenExt();
int QueryGSensor();
int ReadGSensor(int *, int *, int *);
int ScreenHeight();
int ScreenWidth();
void SetGlobalOrientation(int);
void SetGSensor(int);
void SetGSensorEnabled(bool onOff);
bool IsGSensorEnabled();
int GetGSensorOrientation();
void SetOrientation(int);
void AbortTransfer(int);
void AddLastOpen(const char *);
void AddScrolledArea(struct irect_s *, int);
void AddTranslation(const char *, const char *);
int AdjustDirectionKeys(int);
void adjustAreaDefault(unsigned char* data, int scanline, int width, int height);
void adjustAreaWithVibrance(unsigned char* data, int scanline, int width, int height, float vibrance);
void adjustAreaWithLabColorsSaturation(unsigned char* data, int scanline, int width, int height, double koef);
char *arc_filename(const char *);
int base64_decode(const char *, unsigned char *, int);
int base64_encode(const unsigned char *, int, char *);
struct ibitmap_s *BitmapFromScreen(int, int, int, int);
struct ibitmap_s *BitmapFromScreenR(int, int, int, int, int);
struct ibitmap_s *BitmapStretchCopy(const struct ibitmap_s *, int, int, int, int, int, int);
void BookPreparing(const char *);
void BookReady(const char *);
int BtSendFiles(char *, char **);
void CalibrateTouchDevice(enum input_dev_e);
void CalibrateTouchpanel();
int CharWidth(short unsigned int);
char *CheckAssociatedFile(const char *, int);
int CheckFramePointer(int, int, int, int, int, int, int);
void clean_proxy_object(proxy_settings **);
void ClearAllScrolledAreas();
void ClearScreen();
void ClearTimer(iv_timerproc);
void ClearTimerByName(const char *);
void ClearTimerEx(iv_timerprocEx, void *);
void CloseAllTasks();
void CloseConfig(struct iconfig_s *);
void CloseConfigLevel();
void CloseConfigNoSave(struct iconfig_s *);
void CloseContextMenu(struct icontext_menu_s *);
void CloseDialog();
void CloseDictionary();
void CloseFont(struct ifont_s *);
void CloseKeyboard();
void ClosePlayer();
void CloseProgressbar();
void CloseSession(int);
int CloseTask(int, int, int);
struct icolor_map_s *ColorMapCreate(int);
void ColorMapDestroy(struct icolor_map_s **);
int convert_to_utf(const char *, char *, int, const char *);
void CopyActiveFb(void);
struct ibitmap_s *CopyBitmap(const struct ibitmap_s *);
struct ibitmap_s *CopyBitmapDepth4To8(const struct ibitmap_s *);
int copy_file(const char *, const char *);
int copy_file_with_af(const char *, const char *);
proxy_settings *copy_proxy_object(proxy_settings *);
struct ibitmap_s *CoverCacheGet(enum COVERCACHE_STORAGES_e, const char *);
int CoverCachePut(enum COVERCACHE_STORAGES_e, const char *, struct ibitmap_s *);
int FastBookHash(const char *, char *, int);
unsigned int crc32hash(const char *, unsigned int);
struct icontext_menu_s *CreateContextMenu(const char *);
void CreateEmptyNote(const char *);
void CreateNote(const char *, const char *, long long int);
void CreateNoteFromImages(const char *, const char *, long long int, struct ibitmap_s *, struct ibitmap_s *);
void CreateNoteFromPage(const char *, const char *, long long int);
int CreateProfile(const char *, int);
proxy_settings *create_proxy_object(enum proxy_type_e, const char *, int, const char *, const char *);
char *CurrentDateStr();
struct icustomdialog_s *CustomDialogCreate(eBubbleTypes, const char *, int);
void CustomDialogDestroy(struct icustomdialog_s *);
void CustomDialogRender(struct icustomdialog_s *);
void CustomDialogShow(struct icustomdialog_s *);
char *DateStr(long int);
void DeleteInt(struct iconfig_s *, const char *);
int DeleteProfile(const char *);
void delete_proxy(void);
void DeleteString(struct iconfig_s *, const char *);
void Dialog(int, const char *, const char *, const char *, const char *, iv_dialoghandler);
void Dialog3(int, const char *, const char *, const char *, const char *, const char *, iv_dialoghandler);
int DialogSynchro(int, const char *, const char *, const char *, const char *, const char *);
void DimArea(int, int, int, int, int);
void DisableExitHourglass();
void DitherArea(int, int, int, int, int, int);
void DitherAreaQuick2Level(int, int, int, int);
int DownloadTo(int, const char *, const char *, const char *, int);
int DownloadTo_Crutch(int, const char *, const char *, const char *, int);
void DrawApplicationCaption(const char *, const struct irect_s *);
void DrawBitmap(int, int, const struct ibitmap_s *);
void DrawBitmapArea(int, int, const struct ibitmap_s *, int, int, int, int);
void DrawBitmapRect(int, int, int, int, const struct ibitmap_s *, int);
void DrawBitmapRect2(const struct irect_s *, const struct ibitmap_s *);
void DrawBorder(const struct irect_s *, int, int, int, int);
void DrawCircle(int, int, int, int);
void DrawDiagonalHatch(int, int, int, int, int, int);
void DrawDiagonalHatchLimits(int, int, int, int, int, int, int (*)(int, int));
void DrawFrame(int, int, int, int, struct ibitmap_s *, char *, int, struct irect_s *);
void DrawLine(int, int, int, int, int);
void DrawLineEx(int, int, int, int, int, int);
void DrawPager(struct ipager_s *);
int DrawPanel(const struct ibitmap_s *, const char *, const char *, int);
int DrawPanel2(const struct ibitmap_s *, const char *, const char *, int, int);
int DrawPanel3(const struct ibitmap_s *, int, int, int);
int DrawPanel4(const struct ibitmap_s *, const char *, int, int, int);
int DrawPanel5(const struct ibitmap_s *, const char *, const char *, int, int);
void DrawPickOut(int, int, int, int, const char *);
void DrawPickOutEx(const struct irect_s *, const char *);
void DrawPixel(int, int, int);
void DrawRect(int, int, int, int, int);
void DrawRectRound(int, int, int, int, int, int);
void DrawSelection(int, int, int, int, int);
void DrawString(int, int, const char *);
void DrawStringR(int, int, const char *);
int DrawSymbol(int, int, int);
int DrawTabs(const struct ibitmap_s *, int, int);
char *DrawTextRect(int, int, int, int, const char *, int);
char *DrawTextRect2(const struct irect_s *, const char *);
char *DrawTextRect3(int, int, int, int, const char *, int, int *);
void DynamicUpdate(int, int, int, int);
void DynamicUpdateA2(int, int, int, int);
void DynamicUpdateBW(int, int, int, int);
char **EnumBTdevices();
char **EnumConnections();
char **EnumDictionaries();
char **EnumFonts();
struct FontForSort_s *EnumFontsEx();
struct FontForSort_s *EnumFontsFromDirectoryEx(const char *, const char *);
void FreeFontsForSort(struct FontForSort_s *);
char **EnumFontsFromDirectory(const char *, const char *);
char **EnumKeyboards();
char **EnumLanguages();
char **EnumNotepads();
struct ibitmap_s **EnumProfileAvatars();
char **EnumProfiles();
char **EnumThemes();
char **EnumWirelessNetworks();
int escape(const char *, char *, int);
void ExitUpdateA2();
struct iv_filetype_s *FileType(const char *);
struct iv_filetype_s *FileTypeExt(const char *, struct stat *);
void FillArea(int, int, int, int, int);
void FillAreaRect(const struct irect_s *, int);
char *FindIsbnInText(const char *);
int FindTaskByAppName(const char *);
int FindTaskByBook(const char *, int *, int *);
void FineUpdate();
int FineUpdateSupported();
void FlushEvents();
void FlushLastOpen();
void ForcingSleep(void);
void FullUpdate();
void FullUpdateHQ();
int GetA2dpStatus();
void GetActiveTask(int *, int *);
AppStyles GetAppGlobalStyle();
AppStyles GetAppStyle(const char *);
struct iappstyle_s *GetAppStyleEx(const char *);
struct BookSyncStatus_s GetBookSyncStatus(const char *);
char *GetAssociatedFile(const char *, int);
int GetBatteryPower();
int GetBluetoothMode();
struct ibitmap_s *GetBookCover(const char *, int, int);
struct bookinfo_s *GetBookInfo(const char *);
struct bookinfo_s *GetBookInfoExt(const char *, const char *);
char *GetBookISBN(const char *);
int GetBTservice(const char *, const char *);
struct icanvas_s *GetCanvas();
int GetCaptionHeight();
void GetClip(int *, int *, int *, int *);
struct irect_s GetClipRect();
const char *GetCurrentLangText(const char *);
char *GetCurrentProfile();
int GetCurrentTask();
int GetCurrentTrack();
const char *GetCustomFontString();
char *GetDefaultUserAgent();
unsigned char *GetDeviceFingerprint();
char *GetDeviceKey();
char *GetDeviceModel();
int GetDialogShow();
short unsigned int *get_encoding_table(const char *);
void GetEqualizer(int *);
iv_handler GetEventHandler();
const char *GetExternalCardSerialNumber();
const char *GetFileHandler(const char *);
const struct ifont_s *GetFont();
struct ifont_selector_properties *GetFontSelectorProperties();
struct iconfig_s *GetGlobalConfig();
int GetHardwareDepth();
char *GetHardwareType();
const char *GetHeader(int, const char *);
int GetHighVolumeMaxInterval();
int GetHighVolumeTimeout();
char *GetHw3GIMEI();
char *GetHwAddress();
char *GetHwBTAddress();
int GetKeyboardFlags();
void GetKeyboardRect(struct irect_s *);
struct irect_s GetKeyboardRectWithParams(char *, char *, int);
void GetKeyMapping(const char **, const char **);
void GetKeyMappingEx(int, const char **, const char **, int);
struct ibitmap_s *GetKeyResource(const char *, const struct ibitmap_s *);
const char *GetLangText(const char *);
const char *GetLangTextF(const char *, ...);
const char *GetLangTextPlural(const char *, int);
int GetLastNetConnectionError(void);
int NetMgr(int);
int NetMgrStatus(void);
int NetMgrPing(void);
char **GetLastOpen();
int GetListHeaderLevel();
struct irect_s GetMenuRect(const struct imenu_s *);
struct irect_s GetMenuRectEx(const struct imenuex_s *);
int GetMultilineStringWidth(const char *, const int, struct ifont_s *, const int);
struct network_interface_array_s *GetNetDNS(void);
int GetNetList(const char *);
int NetAdd(const char *);
int NetDelete(const char *);
int NetSelect(const char *);
int NetDelete_by_ssid(const char *);
int NetSelect_by_ssid(const char *);
network_interface *GetNetGateway(const network_interface *);
const char *get_partner_id(void);
int get_keylock();
int is_enough_free_space();
int get_screen_dpi();
int isHighPriorityJobRunning();
void startHighPriorityJob(int, int);
void finishHighPriorityJob(int);
int haveDictionaryKeyboard();
network_interface_info *GetNetInfo(const network_interface *);
int GetNetSignalQuality(void);
NET_STATE GetNetState(void);
int GetPagerHeight(struct ipager_s *);
struct irect_s GetPagerRect(struct ipager_s *);
int GetPanelType();
int GetPlayerMode();
int GetPlayerState();
char **GetPlaylist();
void GetPreviousTask(int *, int *);
void GetPreviousTaskInStack(int *, int *);
struct ibitmap_s *GetProfileAvatar(const char *);
int GetProfileType(const char *);
proxy_settings *get_proxy(void);
char *GetProxyUrl();
struct ibitmap_s *GetResource(const char *, const struct ibitmap_s *);
int GetSafeVolumeLimit();
char *GetSerialNumber();
struct iv_sessioninfo_s *GetSessionInfo(int);
int GetSessionStatus(int);
int GetSleepmode();
char *GetSoftwareVersion();
struct iv_filetype_s *GetSupportedFileTypes();
int GetSupportedFileTypesLength();
struct icanvas_s *GetTaskFramebuffer(int);
struct iv_fbinfo_s *GetTaskFramebufferInfo(int);
struct taskinfo_s *GetTaskInfo(int);
int GetTaskList(int *, int);
int GetTemperature();
struct ifont_s *GetThemeFont(const char *, const char *);
int GetThemeInt(const char *, int);
void GetThemeRect(const char *, struct irect_s *, int, int, int, int, int);
const char *GetThemeString(const char *, const char *);
struct iv_mtinfo_s *GetTouchInfo();
struct iv_mtinfo_s *GetTouchInfoI(unsigned int);
int GetTrackPosition();
int GetTrackSize();
char *GetUserAgent();
int GetVolume();
char *GetWaveformFilename();
struct wifi_ap_list_s *GetWiFiScanResults(struct wifi_ap_list_s *);
int GoSleep(int, int);
void GoToBackground();
void hash_add(struct ihash_s *, const char *, const char *);
void hash_clear(struct ihash_s *);
struct ihash_s *hash_copy(struct ihash_s *);
int hash_copy_to(struct ihash_s *, struct ihash_s *);
int hash_count(struct ihash_s *);
void hash_delete(struct ihash_s *, const char *);
void hash_destroy(struct ihash_s *);
void hash_enumerate(struct ihash_s *, iv_hashcmpproc, iv_hashenumproc, void *);
const char *hash_find(struct ihash_s *, const char *);
struct ihash_s *hash_merge(struct ihash_s *, struct ihash_s *);
int hash_merge_to(struct ihash_s *, struct ihash_s *, struct ihash_s *);
struct ihash_s *hash_new(int);
int HavePowerForSoftwareUpdate();
void HideHourglass();
int HQUpdateSupported();
int hw_get_lux_raw(void);
int hw_is_frontlight_auto(void);
int hw_is_frontlight_auto_supported(void);
void hw_set_frontlight_auto_enabled(int);
int GetFrontlightVersion(void);
int GetFrontlightState(void);
void SetFrontlightState(int);
int GetFrontlightEnabled();
void SetFrontlightEnabled(int);
void SetFrontlightStateEx(int, int);
void OpenFrontLightConfig();
void SwitchFrontlightState();
int GetFrontlightColor(void);
void SetFrontlightColor(int);
void IncreaseHighVolumeInterval(int);
void InvertArea(int, int, int, int);
void InvertAreaBW(int, int, int, int);
void InvertAreaMap(int, int, int, int, struct icolor_map_s *);
char IsAnyEvents();
int IsAnyScrolledArea();
int IsBookRTL();
int IsCharging();
int IsInA2Update();
int IsInRect(int, int, const struct irect_s *);
int IsJoystickButtonsPresent();
int IsKeyboardOpened();
int IsKeyPressed(int);
int IsPagerEvent(struct ipager_s *, int, int, int);
int IsPlayingMP3();
short unsigned int IsResourcePresent(const char *);
int IsRTL();
int IsSDinserted();
int IsShowPanelReader();
int IsTaskActive();
int IsUSBconnected();
int iv_access(const char *, int);
void iv_buildpath(const char *);
int iv_closedir(struct __dirstream *);
char *iv_evttype(int);
void iv_fullscreen();
int iv_get_obreey_status();
long int iv_ipc_cmd(long int, long int);
long int iv_ipc_request_with_timeout(long int, long int, unsigned char *, int, int, int);
long int iv_ipc_request(long int, long int, unsigned char *, int, int);
long int iv_ipc_request_secure(long int, long int, unsigned char *, int, int);
int iv_mkdir(const char *, unsigned int);
void iv_nofullscreen();
struct __dirstream *iv_opendir(const char *);
void iv_preload(const char *, int);
struct dirent *iv_readdir(struct __dirstream *);
void iv_reflow_addchar(int, int, int, int, int);
void iv_reflow_addimage(int, int, int, int, int);
void iv_reflow_bt();
void iv_reflow_clear();
void iv_reflow_div();
void iv_reflow_et();
int iv_reflow_getchar(int *, int *);
int iv_reflow_getimage(int *, int *, int *);
char *iv_reflow_getword(int, int *, int *, int *, int *, int *);
void iv_reflow_render(int);
void iv_reflow_start(int, int, int, int, int);
int iv_reflow_subpages();
int iv_reflow_words();
int iv_rename(const char *, const char *);
int iv_rmdir(const char *);
void iv_setbgresponse(int);
void iv_sleepmode(int);
int iv_stat(const char *, struct stat *);
int iv_strcasecmp(const char *, const char *);
int iv_strcmp(const char *, const char *);
int iv_strncasecmp(const char *, const char *, size_t);
int iv_strncmp(const char *, const char *, size_t);
void iv_sync();
int iv_truncate(const char *, int);
int iv_unlink(const char *);
int iv_validate_name(const char *, int);
void iv_wait_task_activation(int);
void LeaveInkViewMain();
struct iapp_caption_s *LoadApplicationCaptionProperties();
struct ibitmap_s *LoadBitmap(const char *);
struct icontext_menu_properties_s *LoadContextMenuProperties();
void LoadHighVolumeTimeout();
struct ibitmap_s *LoadJPEG(const char *, int, int, int, int, int);
void LoadKeyboard(const char *);
void LoadLanguage(const char *);
struct ipager_s *LoadPagerProperties();
void LoadPlaylist(char **);
struct ibitmap_s *LoadPNG(const char *, int);
struct ibitmap_s *LoadPNGStretch(const char *, int, int, int, int);
struct iselection_s *LoadSelectionProperties(const char *);
struct itaskmgr_s *LoadTaskManagerProperties();
struct ibitmap_s *LoadTIFF(const char *, int, int, int, int, int);
void LockDevice();
int LookupNext(char **, char **);
int LookupPrevious(char **, char **);
int LookupWord(const char *, char **, char **);
int LookupWordExact(const char *, char **, char **);
void MD5PartFile(const char *, unsigned char *);
void md5sum(const unsigned char *, int, unsigned char *);
struct irect_s MergeClipRect(const struct irect_s *);
void Message(int, const char *, const char *, int);
int MinimalTextRectWidth(int, const char *);
void MirrorBitmap(struct ibitmap_s *, int);
void MoveBitmap(struct ibitmap_s *, int);
void MoveBitmapRight(struct ibitmap_s *, int);
int move_file(const char *, const char *);
int move_file_with_af(const char *, const char *);
int MultitaskingSupported();
int NetConnect(const char *);
int NetConnect2(const char *, int);
int NetConnectAsync(int (*)(int));
int NetConnectSilent(const char *);
int NetDisconnect();
const char *NetError(int);
void NetErrorMessage(int);
struct iv_netinfo_s *NetInfo();
struct ibitmap_s *NewBitmap(int, int);
int NewSession();
int NewSubtask(char *);
int NewTask(const char *, char *const *, const char *, const char *, const struct ibitmap_s *, unsigned int);
int NewTaskEx(const char *, char *const *, const char *, const char *, const struct ibitmap_s *, unsigned int, int);
void NextTrack();
void NotifyConfigChanged();
void ClearConfig(struct iconfig_s *);
int OpenBook(const char *, const char *, int);
int OpenBook2(const char *, int, const char *const *, int);
void OpenBookmarks(int, long long int, int *, long long int *, int *, int, iv_bmkhandler);
void OpenBTdevicesMenu(char *, int, int, iv_itemchangehandler);
void OpenCalendar();
struct iconfig_s *OpenConfig(const char *, struct iconfigedit_s *);
void OpenConfigEditor(const char *, struct iconfig_s *, struct iconfigedit_s *, iv_confighandler, iv_itemchangehandler);
void OpenConfigSubmenu(const char *, struct iconfigedit_s *);
void OpenConfigSubmenuExt(const char *, struct iconfigedit_s *, int);
void OpenContents(struct tocentry_s *, int, long long int, iv_tochandler);
void OpenContextMenu(const struct icontext_menu_s *);
void OpenControlledDictionaryView(pointer_to_word_hand_t, struct iv_wlist_s *, const char *);
void OpenControlPanel(struct control_panel_s *);
void OpenCustomKeyboard(const char *, const char *, char *, int, int, iv_keyboardhandler);
int GetWordListWithPrefix(const char *, int, char ***);
int OpenDictionary(const char *);
void OpenDictionaryView(struct iv_wlist_s *, const char *);
void OpenDirectorySelector(const char *, char *, int, iv_dirselecthandler);
void OpenDummyList(const char *, const struct ibitmap_s *, char *, iv_listhandler);
void OpenFastTranslation(pointer_to_word_hand_t, struct iv_wlist_s *, int, const char *);
struct ifont_s *OpenFont(const char *, int, int);
void OpenFontSelector(const char *, const char *, int, iv_fontselecthandler);
void OpenFontSelectorEx(const struct ifont_menu_s *);
struct ifont_menu_s GetFontMenuStruct();
void SetFontMenuStruct(struct ifont_menu_s *);
void ClearFontMenuStruct(struct ifont_menu_s *);
void ClearFontListStruct(struct ifont_list_s *);
void OpenKeyboard(const char *, char *, int, int, iv_keyboardhandler);
void OpenKeyboardEx(const char *, char *, int, int, void (*)(char *, void *), void *);
void OpenLastBooks();
void OpenList(const char *, const struct ibitmap_s *, int, int, int, int, iv_listhandler);
void OpenMainMenu();
void OpenMenu(struct imenu_s *, int, int, int, iv_menuhandler);
void OpenMenu3x3(const struct ibitmap_s *, const char **, iv_menuhandler);
void OpenMenuEx(struct imenuex_s *, int, int, int, iv_menuhandler);
void OpenNetworkInfo();
void OpenNotepad(const char *);
void OpenNotesMenu(const char *, const char *, long long int);
void OpenPageSelector(iv_pageselecthandler);
void OpenPlayer();
void OpenProfileSelector();
void OpenProgressbar(int, const char *, const char *, int, iv_dialoghandler);
void OpenRotateBox(iv_rotatehandler);
void OpenTaskList();
void OpenTheme(const char *);
void OpenTimeEdit(const char *, int, int, long int, iv_timeedithandler);
void PackParameters(int, const char *const *, void **, int *);
int PagerHandler(struct ipager_s *, int, int, int);
int PageSnapshot();
int PanelHeight();
void PartialUpdate(int, int, int, int);
void PartialUpdateBlack(int, int, int, int);
void PartialUpdateBW(int, int, int, int);
void PartialUpdateDU4(int, int, int, int);
void PartialUpdateHQ(int, int, int, int);
void Path2String(const char *, char *, int);
void PauseTransfer(int);
void PlayFile(const char *);
void PlayTrack(int);
int PostponeTimedPoweroff(void);
void PowerOff();
void PreviousTrack();
void ProcessEventLoop();
void PrepareForLoop(iv_handler);
void ClearOnExit();
long unsigned int QueryDeviceButtons();
int QueryHeadphone();
int QueryNetwork();
long long int QueryTimer(iv_timerproc);
long long int QueryTimerEx(iv_timerprocEx, void *);
int QueryTouchpanel();
void *QuickDownload(const char *, int *, int);
void *QuickDownloadExt(const char *, int *, int, char *, char *);
void *QuickDownloadExt2(const char *, int *, int, char *, char *, int *);
void QuickFloyd16Dither(unsigned char *, int, int, int, int, int);
void QuickNavigator(int, int, int, int, int, int, int);
int QuickNavigatorSupported(int);
int ReadInt(struct iconfig_s *, const char *, int);
const char *ReadSecret(struct iconfig_s *, const char *, const char *);
const char *ReadString(struct iconfig_s *, const char *, const char *);
int recurse_action(const char *, iv_recurser, void *, int, int);
int RefreshConfig(struct iconfig_s **);
void RegisterFontList(struct ifont_s **, int);
void ReleaseTaskFramebuffer(struct icanvas_s *);
void RemoveScrolledArea(struct irect_s *);
int RenameProfile(const char *, const char *);
void Repaint();
void ResetHighVolumeTimeout();
int RestoreStartupLogo();
void ResumeTransfer(int);
int SafeMode();
int SaveBitmap(const char *, const struct ibitmap_s *);
int SaveConfig(struct iconfig_s *);
void SaveHighVolumeTimeout();
int SaveJPEG(const char *, struct ibitmap_s *, int);
int SavePNG(const char *, const struct ibitmap_s *);
void ScheduleUpdate(int, int, int, int, int);
void SendEvent(iv_handler, int, int, int);
int SendEventSyncTo(int, int, int, int);
int SendEventTo(int, int, int, int);
int SendGlobalRequest(int);
int SendMessageTo(int, int, void *, int);
int SendRequest(int, void *, int, int, int);
int SendRequestNoWait(int, void *, int, int);
int SendRequestTo(int, int, void *, int, int, int);
int SendRequestToNoWait(int, int, void *, int, int);
int SetActiveTask(int, int);
void SetApplicationCaptionHeight(int);
void SetAutoPowerOff(int);
int SetBluetoothMode(int, int);
void SetCanvas(struct icanvas_s *);
void SetClip(int, int, int, int);
void SetClipRect(const struct irect_s *);
void SetConfigEditorBackground(struct ibitmap_s *);
void SetContextMenu(const struct icontext_menu_s *);
void SetCurrentApplicationAttribute(APPLICATION_ATTRIBUTE, int);
void SetCurrentProfile(const char *, int);
int GetProfilesCountAfterEnum();
int ScanProfiles(const char *, int, struct iprofiles_s *);
int GetLocalProfilesLimit();
int GetSDProfilesLimit();
int GetProfilesLimit();
void ClearProfilesStruct(struct iprofiles_s *);
void ClearProfileStruct(struct iprofile_s *);
int GetProfilesList(struct iprofiles_s *);
int DeleteProfileEx(const struct iprofile_s *);
int RenameProfileEx(const struct iprofile_s *, const char *);
int GetCurrentProfileEx(struct iprofile_s *);
int SetCurrentProfileEx(const struct iprofile_s *);
int GetProfilesCount();
void SetEqualizer(int *);
iv_handler SetEventHandler(iv_handler);
iv_handler SetEventHandlerEx(iv_handler);
void SetFileHandler(const char *, const char *);
void SetFont(const struct ifont_s *, int);
void SetHardTimer(const char *, iv_timerproc, int);
void SetHardTimerEx(const char *, iv_timerprocEx, void *, int);
void SetKeyboardRate(int, int);
void SetListHeaderLevel(int);
void SetLoadImageFlags(int);
void SetManualPanelUpdates(int, iv_panelupdateshandler);
void SetMenuFont(struct ifont_s *);
void SetMessageHandler(iv_msghandler);
void SetMinimalXScrollIndent(struct irect_s *, int);
void SetMinimalYScrollIndent(struct irect_s *, int);
int SetPanelSeparatorEnabled(int);
int IsPanelSeparatorEnabled();
void InitPanel();
void SetPanelKeyForFullScreenEnabled(const char *);
void SetPanelType(int);
void SetPlayerMode(int);
void SetPlayerState(int);
void SetPort(int);
int SetProfileAvatar(const char *, struct ibitmap_s *);
int set_proxy(proxy_settings *);
void SetProxy(int, const char *, int, const char *, const char *);
void SetQuickNavigatorXY(int, int);
void SetReadingMode(int, int, int);
int SetRequestListener(int, int, iv_requestlistener);
void SetRTLBook(int);
int SetSessionFlag(int, int, void *);
void SetShowPanelReader(int);
int SetSubtaskInfo(int, int, const char *, const char *);
int SetTaskParameters(int, const char *, const char *, struct ibitmap_s *, unsigned int);
void SetTextStrength(int);
void SetTrackPosition(int);
void SetTransparentColor(struct ibitmap_s **, int);
void SetUserAgent(int, const char *);
void SetVolume(int);
void SetWeakTimer(const char *, iv_timerproc, int);
void SetWeakTimerEx(const char *, iv_timerprocEx, void *, int);
void ShowHourglass();
void ShowHourglassAt(int, int);
void ShowHourglassForce();
void ShowHourglassForceAt(int, int);
void ShowPureHourglass();
void ShowPureHourglassForce();
void SoftUpdate();
void SoftUpdateHQ();
void StartPanelProgress(int, int);
int StartSoftwareUpdate();
void StopPanelProgress();
void Stretch(const unsigned char *, int, int, int, int, int, int, int, int, int);
void StretchArea(const unsigned char *, int, int, int, int, int, int, int, int, int, int, int);
void StretchAreaBW(const unsigned char *, int, int, int, int, int, int, int, int, int, int);
void StretchBitmap(int, int, int, int, const struct ibitmap_s *, int);
int StringWidth(const char *);
int StringWidthExt(const char *, int);
void SubtaskFinished(int);
void SwitchBookmark(int, long long int, int *, long long int *, int *, int, iv_bmkhandler);
int SwitchSubtask(int);
int TestCurrentApplicationAttribute(APPLICATION_ATTRIBUTE);
int TextRectHeight(int, const char *, int);
int TextRectHeightEx(int, int, const char *, int);
void TileBitmap(int, int, int, int, const struct ibitmap_s *);
void TogglePlaying();
void Transparent(int, int, int, int, int);
void TransparentRect(struct irect_s, int);
void trim_right(char *);
int ucs2utf(const short unsigned int *, char *, int);
int unescape(const char *, char *, int);
int unlink_file_with_af(const char *);
void UnpackParameters(void *, int, int *, char ***);
void UpdateConfigPage(const char *, struct iconfigedit_s *);
void UpdateCurrentConfigPage();
void UpdateMenuEx(struct imenuex_s *);
int UpdateProgressbar(const char *, int);
int utf2ucs(const char *, short unsigned int *, int);
int utf2ucs4(const char *, unsigned int *, int);
int utf_tolower_ext(char *, int, char **, int *);
int utf_toupper_ext(char *, int, char **, int *);
void vhash_add(struct ihash_s *, const char *, const void *);
void vhash_delete(struct ihash_s *, const char *);
const void *vhash_find(struct ihash_s *, const char *);
struct ihash_s *vhash_new(int, void *(*)(void *), iv_hashdelproc);
void WaitForUpdateComplete();
int WiFiPower(int);
struct wifi_ap_list_s *WiFiScanProcessGetResults(void);
void WiFiScanProcessSetSelectiveList(struct wifi_ap_list_s *);
int WiFiScanProcessStart(void);
int WiFiScanProcessStop(void);
char *wpa_passphrase(char *, char *);
void WriteInt(struct iconfig_s *, const char *, int);
void WriteIntVolatile(struct iconfig_s *, const char *, int);
void WriteSecret(struct iconfig_s *, const char *, const char *);
int WriteStartupLogo(const struct ibitmap_s *);
void WriteString(struct iconfig_s *, const char *, const char *);
void WriteStringVolatile(struct iconfig_s *, const char *, const char *);
struct ibitmap_s *zLoadBitmap(void *, const char *);
struct hw_event_data_pointer_s {
  int id;
  int x;
  int y;
  int pressure;
  enum input_dev_e devtype;
};
struct hw_event_data_common_s {
  int mod;
  int par1;
  int par2;
};
struct hw_event_s {
  int type;
  union {
    struct hw_event_data_common_s common;
    struct hw_event_data_pointer_s pointer;
  };
  struct timeval time;
};
typedef struct hw_event_s hw_event;
int hw_init();
void hw_close();
void hw_setglobalkeymask(long int, long int, long int);
void iv_setup_touchpanel();
void iv_setup_gsensor();
void iv_update_orientation(int);
int hw_get_keylock();
]]
